% PPIPARC DOCUMENT CLASS -- version alpha 1.2
% for Problems of Information Transmission
% designed by V.S.Kozyakin on 17.01.2000
%
%CREDITS:
%
%As the basis for this class the LNCSE DOCUMENT CLASS -- version
%1.0 for Lecture Notes in Computational Science and Engineering by
%Springer Verlag (lsnce.cls) was taken in which plenty of changes
%and customizations were made. In particular:
%    a. some options were removed and instead option
%    "yap" was added
%    b. completely changed contents, headings, author list in
%    contents etc.
%    c. sizes, fonts, page layout were changed
%    d. plenty of commands to tune volume numbers, years of issue
%    etc. were made
%
%To make possible independent citations and equations referencing
%in different articles in the class were included parts from the
%packages chapterbib.sty Version 1.6 (27-SEP-1996) by Donald
%Arseneau and
%%     C I T E . S T Y
%%
%%     version 3.7  (April 1997)
%%
%%     Compressed, sorted lists of numerical citations: [11-16]
%%     see also OVERCITE.STY and DRFTCITE.STY
%%
%%     Copyright (C) 1989-1997 by Donald Arseneau
%%     These macros may be freely transmitted, reproduced, or modified
%%     provided that this notice is left intact.
%%
%The necessary customizations were made to remove unneeded options
%and to make possible independent referencing without using \input
%command as in chapterbib.sty.
%
%To allow forward/backward search it was added modified and
%shortened version of the srcltx.sty by Alexander Simonic
%
%
%The necessary strings from the packages indentfirst.sty and textcase.sty by David
%Carlisle were inserted too.
%
%======================================================================

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{ppiparc}[1999/12/31 v1.0 ^^JLaTeX
document class for Problems of Information Transmission]
% Options

\let\if@envcntreset\iffalse
\DeclareOption{envcountreset}{\let\if@envcntreset\iftrue}
\let\if@envcntsect\iffalse
\DeclareOption{envcountsect}{\let\if@envcntsect\iftrue}
\let\if@yap\iffalse
\DeclareOption{yap}{\let\if@yap\iftrue}
\let\if@winedt\iffalse
\DeclareOption{winedt}{\let\if@winedt\iftrue}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

\ProcessOptions

\LoadClass[twoside,10pt]{article}

\if@yap \RequirePackage{graphicx}
\DeclareGraphicsRule{.gif}{bmp}{}{}
\DeclareGraphicsRule{.pcx}{bmp}{}{}
\DeclareGraphicsRule{.png}{bmp}{}{}
\DeclareGraphicsRule{.tga}{bmp}{}{}
\DeclareGraphicsRule{.tif}{bmp}{}{}
\DeclareGraphicsRule{.tiff}{bmp}{}{} \fi
%
%This is redefinition of \include command to eliminate making
%new page for each \include - in this class new page entered by
%the \title command
%
%
\if@winedt%
\AtBeginDocument{
\gdef\MainFile{\jobname.tex}% ".tex" needed for MiKTeX
\gdef\CurrentInput{\MainFile}
\newcount\INPSP
\global\INPSP=0
\def\WinEdt#1{\typeout{:#1}} % WinEdt LOG MODE and INPUT
% ------------------------------------------------------------------------
\def\PUSH#1{%
\ifnum\INPSP=0 \global\let\INPSTACKA=\CurrentInput \else%
\ifnum\INPSP=1 \global\let\INPSTACKB=\CurrentInput \else%
\ifnum\INPSP=2 \global\let\INPSTACKC=\CurrentInput \else%
\ifnum\INPSP=3 \global\let\INPSTACKD=\CurrentInput \else%
\ifnum\INPSP=4 \global\let\INPSTACKE=\CurrentInput \else%
\ifnum\INPSP=5 \global\let\INPSTACKF=\CurrentInput \else%
               \global\let\INPSTACKX=\CurrentInput \fi\fi\fi\fi\fi\fi%
\gdef\CurrentInput{#1}%
\WinEdt{<+ \CurrentInput}%
\global\advance\INPSP by 1}
%
\def\POP{%
\ifnum\INPSP>0 \global\advance\INPSP by -1  \fi%
\ifnum\INPSP=0 \global\let\CurrentInput=\INPSTACKA \else%
\ifnum\INPSP=1 \global\let\CurrentInput=\INPSTACKB \else%
\ifnum\INPSP=2 \global\let\CurrentInput=\INPSTACKC \else%
\ifnum\INPSP=3 \global\let\CurrentInput=\INPSTACKD \else%
\ifnum\INPSP=4 \global\let\CurrentInput=\INPSTACKE \else%
\ifnum\INPSP=5 \global\let\CurrentInput=\INPSTACKF \else%
               \global\let\CurrentInput=\INPSTACKX \fi\fi\fi\fi\fi\fi%
\WinEdt{<-}%
}
% Hack native TeX `input' primitive for
\let\TeX@input=\@@input % save Natural TeX input command, saved by LaTeX.
\def\src@input#1{%
\PUSH{#1}%
\TeX@input #1\relax%
\POP%
}

\def\a@input#1{\src@file=\expandafter{\the\src@file#1}\s@input}
\def\s@input{\futurelet\next\p@input}
\let\L@char=z \let\O@char=.
\def\p@input{\ifcat\next\O@char \let\go\a@input
             \else \ifcat\next\L@char % Next char letter of other
                       \let\go\a@input \else \let\go\d@input \fi
             \fi \go}
\def\d@input{\src@input{\the\src@file}}

\let\sv@input\@input
\let\sv@input@\@input@

\def\@input#1{%
  \IfFileExists{#1}{\src@input{\@filef@und}}{\typeout{No file #1.}}}
\long\def \InputIfFileExists#1#2{%
  \IfFileExists{#1}%
    {#2\@addtofilelist{#1}\src@input{\@filef@und}}}
}
\fi

\def\@include#1 {%
  %\clearpage
  \if@filesw
    \immediate\write\@mainaux{\string\@input{#1.aux}}%
  \fi
  \@tempswatrue
  \if@partsw
    \@tempswafalse
    \edef\reserved@b{#1}%
    \@for\reserved@a:=\@partlist\do
      {\ifx\reserved@a\reserved@b\@tempswatrue\fi}%
  \fi
  \if@tempswa
    \let\@auxout\@partaux
    \if@filesw
      \immediate\openout\@partaux #1.aux
      \immediate\write\@partaux{\relax}%
    \fi
    \@input@{#1.tex}%
    %\clearpage
    \@writeckpt{#1}%
    \if@filesw
      \immediate\closeout\@partaux
    \fi
  \else
    \deadcycles\z@
    \@nameuse{cp@#1}%
  \fi
  \let\@auxout\@mainaux}
%%
%% This is file `textcase.sty',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% textcase.dtx  (with options: `package')
%%
%% Source File: textcase.dtx
%% Copyright 1997 1998 David Carlisle
%%
%% This file may be distributed under the terms of the LPPL.
%% See 00readme.txt for details.
%\NeedsTeXFormat{LaTeX2e} \ProvidesPackage{textcase}
%       [1998/11/12 v0.06 Text only upper/lower case changing (DPC)]
\def\@uclcnotmath#1#2#3#4{\begingroup
      #1%
      \def\({$}\let\)\(%
      \def\NoCaseChange##1{\noexpand\NoCaseChange{\noexpand##1}}
      \@nonchangecase\label
      \@nonchangecase\ref
      \@nonchangecase\ensuremath
      \@nonchangecase\\%
      \def\cite##1##{\toks@{\noexpand\cite##1}\@citex}%
      \def\@citex##1{\NoCaseChange{\the\toks@{##1}}}%
      \def\reserved@a##1##2{\let#2\reserved@a}%
      \expandafter\reserved@a\@uclclist\reserved@b{\reserved@b\@gobble}%
      \protected@edef\reserved@a{\endgroup
          \noexpand\@skipmath#3#4$\valign$}%
      \reserved@a}
\def\@nonchangecase#1{\def#1##1{\NoCaseChange{#1{##1}}}}
\let\NoCaseChange\@firstofone
\def\@skipmath#1#2$#3${%
  \@skip@nonchangecase#1#2\NoCaseChange\valign
  \ifx\valign#3%
  \else
    $#3$%
    \expandafter\@skipmath\expandafter#1%
  \fi}
\def\@skip@nonchangecase#1#2\NoCaseChange#3{%
  #1{#2}%
  \ifx\valign#3%
  \else
    #3%
    \expandafter\@skip@nonchangecase\expandafter#1%
  \fi}
\DeclareRobustCommand\MakeTextUppercase{%
  \@uclcnotmath{\def\i{I}\def\j{J}}{##1##2}\uppercase}
\protected@edef\MakeTextUppercase#1{\MakeTextUppercase{#1}}
\DeclareRobustCommand\MakeTextLowercase{%
  \@uclcnotmath{}{##2##1}\lowercase}
\protected@edef\MakeTextLowercase#1{\MakeTextLowercase{#1}}
%\DeclareOption{overload}{%
  \expandafter\let\csname MakeUppercase \expandafter\endcsname
                  \csname MakeTextUppercase \endcsname
  \expandafter\let\csname MakeLowercase \expandafter\endcsname
                  \csname MakeTextLowercase \endcsname%}
%\ProcessOptions

%%
%% This is file `indentfirst.sty',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% indentfirst.dtx  (with options: `package')
%%
%% This is a generated file.
%%
%% Copyright 1993 1994 1995 1996 1997 1998 1999
%% The LaTeX3 Project and any individual authors listed elsewhere
%% in this file.
%%
%% This file is part of the Standard LaTeX `Tools Bundle'.
%% -------------------------------------------------------
%%
%% It may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.1
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%% and version 1.1 or later is part of all distributions of LaTeX
%% version 1999/06/01 or later.
%%
%% The list of all files belonging to the LaTeX `Tools Bundle' is
%% given in the file `manifest.txt'.
%%
%% File: indent.dtx Copyright (C) 1991-1994 David Carlisle
\let\@afterindentfalse\@afterindenttrue
\@afterindenttrue
%%
%% End of file `indentfirst.sty'.


\AtBeginDocument{\global\advance\c@inputfile\@ne \xdef\the@ipfilectr{@-\the\c@inputfile}%
  \immediate\write\@auxout{\string\gdef\string\@extra@binfo{\@extra@b@citeb}}}

\AtEndDocument{\label{lastp@ge}\gdef\the@ipfilectr{}%
  \immediate\write\@auxout{\string\gdef\string\@extra@binfo{\@extra@b@citeb}}}

\def\MAIKlogo{MAIK~``Nauka/Interperiodica''}
\def\@seccntformat#1{\csname the#1\endcsname.~}


\setlength{\textwidth}{135mm}%
\setlength{\textheight}{209mm}% !!!211
%\setlength{\oddsidemargin}{-0.29cm}% !!!
%\setlength{\evensidemargin}{-0.29cm}% !!!
\oddsidemargin=12.5mm
\evensidemargin=12.5mm
\setlength{\marginparwidth}{25pt}% !!!
\setlength{\topmargin}{-.29cm}% !!! 1.11=2.54-1.25
\setlength\headsep{.46cm}% !!!
\addtolength{\headsep}{-\topmargin}% !!!
\addtolength{\headsep}{-\headheight}% !!!
\newlength{\ArticleHeadDepth}
\setlength{\ArticleHeadDepth}{1.25cm}
\newlength{\FirstHeadDepth}
\setlength{\FirstHeadDepth}{\ArticleHeadDepth}
\newlength{\dblrulegap}
\setlength{\dblrulegap}{2.7pt}
\newcommand{\dblrulefill}[1]{\vbox{\hrule height0.3pt width#1\vskip%
\dblrulegap\hrule height0.3pt width#1}}
\newlength{\dblruleheight}
\settoheight{\dblruleheight}{\dblrulefill{\textwidth}}
\newlength{\dblrulegapC}
\setlength{\dblrulegapC}{2pt}
\newcommand\dblrulefillC{\vbox{\hrule height1pt width\textwidth\vskip%
\dblrulegap\hrule height1pt width\textwidth}}
\newlength{\dblruleheightC}
\settoheight{\dblruleheightC}{\dblrulefillC}
\newlength{\@fhd}
\newlength{\@rubwidth}
\newlength{\@restrub}
\setlength{\footskip}{10mm}%9
%\settoheight{\footskip}{\footnote A}%
%\addtolength{\footskip}{0.2cm}%

\widowpenalty=10000%
\clubpenalty=10000%

% LaTeX does not provide a command to enter the authors institute
% addresses. The \institute command is defined here.


\newcounter{@inst}
\newcounter{@auth}
\newcounter{auco}
\def\andname{and}
\def\lastandname{\unskip, and}
\newdimen\instindent
\newbox\authrun
%\newbox\titrun

\def\title#1{\label{lastp@ge}\gdef\@title{#1}}

%\def\received#1{\gdef\@received{#1}}\edef\@received{When received?}%
%\def\titlerunning#1{\gdef\@titlerunning{#1}}\edef\@titlerunning{}%
\def\authorrunning#1{\gdef\@authorrunning{#1}}\edef\@authorrunning{}%
\def\toctitle#1{\gdef\@toctitle{\small#1}}\edef\@toctitle{}%
\def\tocauthor#1{\gdef\@tocauthor{\small\bf#1}}\edef\@tocauthor{}
\def\JournalName#1{\gdef\@JournalName{#1}}\edef\@JournalName{Problems of Information Transmission}%
\def\JournalISSNCode#1{\gdef\@JournalISSNCode{#1}}\edef\@JournalISSNCode{0005-1179%CODE-CODE
}%
\def\IssuePrice#1{\gdef\@IssuePrice{#1}}\edef\@IssuePrice{?9.9?}%
\def\ContentsHeadLineA#1{\gdef\@ContentsHeadLineA{#1}}
\edef\@ContentsHeadLineA{Vol.~\noexpand\@TransVolumeNo,%
~No.~\noexpand\@TransIssueNo,~Part~\noexpand\@TransPartNo,%
~\noexpand\@TransYearOfIssue}%
\def\ContentsHeadLineB#1{\gdef\@ContentsHeadLineB{#1}}
\edef\@ContentsHeadLineB{Simultaneous English language
translation of the journal is avaliable from \noexpand\MAIKlogo
(Russia).}
\def\ContentsHeadLineC#1{\gdef\@ContentsHeadLineC{#1}}
\edef\@ContentsHeadLineC{Distributed worldwide by
Kluwer Academic/Plenum Publishers.
{\noexpand\itshape Problems of Information Transmission}
ISSN \noexpand\@JournalISSNCode.}
\def\TransYearOfIssue#1{\gdef\@TransYearOfIssue{#1}}\edef\@TransYearOfIssue{111?}%
\def\TransCopyrightYear#1{\gdef\@TransCopyrightYear{#1}}\edef\@TransCopyrightYear{222?}%
\def\TransVolumeNo#1{\gdef\@TransVolumeNo{#1}}\edef\@TransVolumeNo{4?}%
\def\TransIssueNo#1{\gdef\@TransIssueNo{#1}}\edef\@TransIssueNo{5?}%
\def\TransPartNo#1{\gdef\@TransPartNo{#1}}\edef\@TransPartNo{0?}%
\def\OrigYearOfIssue#1{\gdef\@OrigYearOfIssue{#1}}\edef\@OrigYearOfIssue{20??}%
\def\OrigCopyrightYear#1{\gdef\@OrigCopyrightYear{#1}}\edef\@OrigCopyrightYear{666?}%
\def\OrigVolumeNo#1{\gdef\@OrigVolumeNo{#1}}\edef\@OrigVolumeNo{??}%
\def\OrigIssueNo#1{\gdef\@OrigIssueNo{#1}}\edef\@OrigIssueNo{на рецензировании}%
\def\OrigPages#1{\gdef\@OrigPages{#1}}\edef\@OrigPages{00?--99?}%
\def\OrigCopyrightedAuthors#1{\gdef\@OrigCopyrightedAuthors{#1}}%
\edef\@OrigCopyrightedAuthors{Ivanoff, Petroff, Sidoroff ???}%
\def\ArticleDataHeadA#1{\gdef\@ArticleDataHeadA{#1}}\edef\@ArticleDataHeadA%
{\noexpand\@JournalName,~Vol.~\noexpand\@TransVolumeNo,~No.~\noexpand\@TransIssueNo,~%
Part~\noexpand\@TransPartNo,~\noexpand\@TransYearOfIssue,%
~pp.~\noexpand\thepage--\noexpand\pageref{lastp@ge}.}%
\def\ArticleDataHeadB#1{\gdef\@ArticleDataHeadB{#1}}\edef\@ArticleDataHeadB%
{Translated from Avtomatika i Telemekhanika,~No.~\noexpand\@OrigIssueNo,~%
\noexpand\@OrigYearOfIssue,~pp.~\noexpand\@OrigPages.}%
\def\ArticleDataHeadC#1{\gdef\@ArticleDataHeadC{#1}}\edef\@ArticleDataHeadC%
{Original Russian Text Copyright~\noexpand\copyright~\noexpand\@OrigCopyrightYear~%
by~\noexpand\@OrigCopyrightedAuthors.}%
\def\ArticleDataFoot#1{\gdef\@ArticleDataFoot{#1}}%
%\def\Rubrika#1{\gdef\@@Rubrika{#1}\gdef\@Rubrika{\raisebox{.5\dblruleheight}%
%{\raisebox{-.5\height}{%\normalfont\large
%\bfseries\shortstack{\huge \it#1}}}}}%
\def\Rubrika#1{\gdef\@@Rubrika{#1}\gdef\@Rubrika{%
%\begingroup
%{\hbox to 135mm {
{\huge \it #1}%}%\end{flushright}
               %\endgroup
                        }}%

\edef\@Rubrika{}
\edef\@@Rubrika{}%

\def\f@urdigit#1{%
\begingroup\count0=#1%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\one@mydate{\the\count1}%
\divide\count0by10%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\two@mydate{\the\count1}%
\divide\count0by10%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\three@mydate{\the\count1}%
\divide\count0by10%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\four@mydate{\the\count1}%
\endgroup%
\four@mydate\three@mydate\two@mydate\one@mydate}

\def\tw@digit#1{%
\begingroup\count0=#1%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\one@mydate{\the\count1}%
\divide\count0by10%
\count1=\count0\divide\count1by10\multiply\count1by-10\advance\count1by\count0%
\xdef\two@mydate{\the\count1}%
\endgroup%
\two@mydate\one@mydate}


\edef\@ArticleDataFoot{\noexpand\@JournalISSNCode/%
\noexpand\tw@digit{\noexpand\@TransYearOfIssue}/%
\noexpand\tw@digit{\noexpand\@TransVolumeNo}%
\noexpand\tw@digit{\noexpand\@TransIssueNo}-%
\noexpand\f@urdigit{\noexpand\thepage}%
\noexpand\$\noexpand\@IssuePrice~\noexpand\copyright~%
\noexpand\@TransCopyrightYear~\noexpand\MAIKlogo}%


\def\clearheadinfo{\gdef\@author{No Author Given}%
                   \gdef\@title{No Title Given}%
                   \gdef\@subtitle{}%
                   \gdef\@institute{No Institute Given}%
                   \gdef\@thanks{}%
                   %\gdef\@titlerunning{}
                   \gdef\@authorrunning{}%
                   \gdef\@toctitle{}
                   \gdef\@tocauthor{}}

\setlength\footnotesep{7.7\p@}
\setlength\textfloatsep{8mm\@plus 2\p@ \@minus
4\p@} \setlength\intextsep   {8mm\@plus 2\p@
\@minus 2\p@}

\@ifundefined{@extra@binfo}{
  \def\bibcite#1#2{\global\@namedef{b@#1\@extra@binfo}{#2}}
}{}

\@ifundefined{@extra@b@citeb}{%
 \def\@citex[#1]#2{%  Add \@extra@b@citeb to \cite
   \let\@citea\@empty
   \@cite{\@for\@citeb:=#2\do
     {\@citea\let\@citea\citepunct
      \edef\@citeb{\expandafter\@firstofone\@citeb}%
      \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
      \@ifundefined{b@\@citeb \@extra@b@citeb}{\mbox{\reset@font\bf ?}%
         \@warning{Citation `\@citeb' in file `\@currentipfile'
             on page \thepage \space undefined}\G@refundefinedtrue}%
      {\hbox{\citeform{\csname b@\@citeb \@extra@b@citeb\endcsname}}}}}{#1}}
%
\def\nocite#1{\@bsphack % Add \@extra@b@citeb to \nocite
  \@for\@citeb:=#1\do{%
    \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
    \@ifundefined{b@\@citeb\@extra@b@citeb}{\G@refundefinedtrue
        \@warning{Citation `\@citeb' in file `\@currentipfile' undefined}}{}}%
  \@esphack}
%
}{}% 2nd arg of \@ifundefined{@extra@b@citeb}

\def\@firstofone#1{#1}

\@ifundefined{citeform}{\let\citeform=\relax}{}
\@ifundefined{citepunct}{\def\citepunct{,\penalty\@m\ }}{}

\xdef\@savedjobname{\jobname}% save root file name as a macro
\let\@currentipfile\@savedjobname
\gdef\the@ipfilectr{}
\def\@extra@b@citeb{\the@ipfilectr}
\newcount\c@inputfile \global\c@inputfile=0

\gdef\@extra@binfo{}  % in case .aux files are left from old run.

\@ifundefined{reset@font}{\let\reset@font\relax}{}
\@ifundefined{G@refundefinedtrue}{\let\G@refundefinedtrue\relax}{}

\let\cb@bibliographystyle\bibliographystyle
\def\cb@roottest{2\ifx\the@ipfilectr\@empty 1\else2\fi}

\def\bibliographystyle#1{\if\cb@roottest\cb@bibliographystyle{#1}\fi}

\def\bibliography#1{\if\cb@roottest
   \if@filesw\immediate\write\@auxout{\string\bibdata{#1}}\fi
   \fi \@input{\@currentipfile.bbl}}

\let\@test@defiii\@testdef

%\def\@testdef#1#2#3{%
%  \if#1b\relax\@test@defiii b{#2\@extra@binfo}{#3}%
%  \else \@test@defiii #1{#2}{#3}\fi}

\def\sectionbib#1#2{% Macro to convert \thebibliography command
 \long\def\@tempa##1##{% to parse beginning of old def
  \long\def\@tempa####1\endthebibliography{}\def\@tempb{##1}\@tempa}%
 \expandafter\@tempa\thebibliography{}{}\endthebibliography
 \begingroup \toks@{#1}%
 \cb@warning {The sectionbib option changes \string"\expandafter
  \strip@prefix\meaning\@tempb\string" to \string"\the\toks@\string"
  in \string\thebibliography }\endgroup
 \let\cb@thebibliography\thebibliography
 \def\thebibliography{\let\@currentlabel\@empty
   \ifx\the@ipfilectr\@empty \else
   \expandafter\expandafter\expandafter\cb@sectionbib\fi
   \cb@thebibliography}%
 \expandafter\def\expandafter\cb@sectionbib\@tempb##1{#1{\bibname
 \ifx\@mkboth\@gobbletwo\else\markright{\MakeUppercase{\bibname}}\fi% like \@mkright
 \ifx\@currentlabel\@empty \addcontentsline{toc}{#2}{\bibname}\fi}}}

\def\strip@prefix#1>{}
\@ifundefined{bibname}{\def\bibname{Bibliography}}{}

\def\ref#1{\expandafter\@setref\csname r@#1\@extra@b@citeb\endcsname\@firstoftwo{#1\@extra@b@citeb}}
\def\pageref#1{\expandafter\@setref\csname r@#1\@extra@b@citeb\endcsname
                                   \@secondoftwo{#1\@extra@b@citeb}}
\def\label#1{\@bsphack
  \protected@write\@auxout{}%
         {\string\newlabel{#1\@extra@b@citeb}{{\@currentlabel}{\thepage}}}%
  \@esphack}


\setcounter{secnumdepth}{2}

\newcounter {chapter}
\renewcommand\thechapter      {\@arabic\c@chapter}

\newif\if@mainmatter \@mainmattertrue
\newcommand\frontmatter{\cleardoublepage
            \@mainmatterfalse\pagenumbering{Roman}}
\newcommand\mainmatter{\cleardoublepage
       \@mainmattertrue\pagenumbering{arabic}}
\newcommand\backmatter{\if@openright\cleardoublepage\else\clearpage\fi
      \@mainmatterfalse}

\renewcommand\part{\cleardoublepage
                 \thispagestyle{empty}%
                 \if@twocolumn
                     \onecolumn
                     \@tempswatrue
                   \else
                     \@tempswafalse
                 \fi
                 \null\vfil
                 \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \huge\bfseries \partname~\thepart
       \par
       \vskip 20\p@
     \fi
     \Huge \bfseries #2\par}%
    \@endpart}
\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}
\def\@endpart{\vfil\newpage
              \if@twoside
                \null
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}

\newcommand\chapter{\clearpage
                    \thispagestyle{empty}%
                    \global\@topnum\z@
                    \@afterindentfalse
                    \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                       \if@mainmatter
                         \refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                  {\protect\numberline{\thechapter}#1}%
                       \else
                         \addcontentsline{toc}{chapter}{#1}%
                       \fi
                    \else
                      \addcontentsline{toc}{chapter}{#1}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makechapterhead{#2}]%
                    \else
                      \@makechapterhead{#2}%
                      \@afterheading
                    \fi}
\def\@makechapterhead#1{%
% \vspace*{50\p@}%
  {\parindent \z@ \center
    \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
        \large\bfseries \@chapapp{} \thechapter
        \par\nobreak
        \vskip 20\p@
      \fi
    \fi
    \interlinepenalty\@M
    \Large \bfseries #1\par\nobreak
    \vskip 40\p@
  }}
\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi}
\def\@makeschapterhead#1{%
% \vspace*{50\p@}%
  {\parindent \z@ \center
    \normalfont
    \interlinepenalty\@M
    \Large \bfseries  #1\par\nobreak
    \vskip 40\p@
  }}

\def\doi#1{\gdef\@doi{#1}}\edef\@doi{ ???????? No DOI number!}%
\def\EDN#1{\gdef\@EDN{\uppercase{#1}}}\edef\@EDN{ ???????? No EDN number!}%

\endinput
